/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.cim;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.StringUtil;

public class CIMObjectPath
implements Serializable {
    static final long serialVersionUID = 200L;
    private String nameSpace = "";
    private String objectName = "";
    private Vector keys = new Vector();
    private String host = "";

    public CIMObjectPath() {
    }

    public CIMObjectPath(String objectPath) {
        this();
        this.parseOp(objectPath);
    }

    public CIMObjectPath(String elementName, String nameSpace) {
        this(elementName);
        this.nameSpace = CIMNameSpace.validateNameSpace(nameSpace);
    }

    public CIMObjectPath(String objectName, Vector keys) {
        this(objectName);
        this.keys = (Vector)keys.clone();
    }

    public void addKey(String name, CIMValue value) {
        CIMProperty cp = new CIMProperty(name, value);
        this.addKey(cp);
    }

    public void addKey(CIMProperty cp) {
        if (cp.getName() == null || cp.getValue() == null || cp.getValue().isNull()) {
            throw new IllegalArgumentException("name or value can not be null");
        }
        cp.setKey(true);
        this.keys.addElement(cp);
    }

    public CIMProperty getKey(String name) {
        Iterator iter = this.keys.iterator();
        while (iter.hasNext()) {
            CIMProperty key = (CIMProperty)iter.next();
            if (!key.getName().equalsIgnoreCase(name)) continue;
            return key;
        }
        return null;
    }

    public Vector getKeys() {
        return (Vector)this.keys.clone();
    }

    public void setKeys(Vector v) {
        this.keys = v;
        Enumeration keys = v.elements();
        while (keys.hasMoreElements()) {
            CIMProperty key = (CIMProperty)keys.nextElement();
            key.setKey(true);
        }
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public String getHost() {
        return this.host;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void parse(String p) {
        this.parseOp(p);
    }

    public void setHost(String host) {
        this.host = host == null ? "" : host;
    }

    public void setNameSpace(String ns) {
        this.nameSpace = CIMNameSpace.validateNameSpace(ns);
    }

    public void setObjectName(String objectName) {
        if (objectName != null && objectName.indexOf(58) != -1) {
            objectName = objectName.substring(0, objectName.indexOf(58));
        }
        this.objectName = objectName;
    }

    public String toString() {
        boolean haveNameSpace;
        StringBuffer buffer = new StringBuffer();
        boolean haveHost = this.host != null && this.host.length() > 0;
        boolean bl = haveNameSpace = this.nameSpace != null && this.nameSpace.length() > 0;
        if (haveHost) {
            buffer.append("//");
            buffer.append(this.host);
        }
        if (haveNameSpace) {
            if (this.nameSpace.charAt(0) != '/') {
                buffer.append('/');
            }
            buffer.append(this.nameSpace);
        }
        if (this.objectName != null && this.objectName.length() != 0) {
            if (haveHost || haveNameSpace) {
                buffer.append(':');
            }
            buffer.append(this.objectName);
            Enumeration e = this.keys.elements();
            if (e.hasMoreElements()) {
                buffer.append('.');
                while (e.hasMoreElements()) {
                    CIMProperty pe = (CIMProperty)e.nextElement();
                    if (pe == null) continue;
                    buffer.append(pe.getName());
                    buffer.append('=');
                    CIMValue cv = pe.getValue();
                    if (cv != null) {
                        Object value = cv.getValue();
                        if (value instanceof String) {
                            buffer.append(StringUtil.quote(value.toString()));
                        } else if (value instanceof CIMObjectPath) {
                            buffer.append(value.toString());
                        } else if (value instanceof CIMDateTime) {
                            buffer.append('\"');
                            buffer.append(value.toString());
                            buffer.append('\"');
                        } else {
                            buffer.append(String.valueOf(value));
                        }
                    } else {
                        buffer.append("null");
                    }
                    if (!e.hasMoreElements()) continue;
                    buffer.append(',');
                }
            }
        }
        return buffer.toString();
    }

    public int hashCode() {
        int hashcode = this.getObjectName().toLowerCase().hashCode();
        if (this.getHost() != null) {
            hashcode ^= this.getHost().toLowerCase().hashCode();
        }
        if (this.getNameSpace() != null) {
            hashcode ^= this.getNameSpace().toLowerCase().hashCode();
        }
        for (int i = 0; i < this.keys.size(); ++i) {
            CIMValue value;
            CIMProperty property = (CIMProperty)this.keys.elementAt(i);
            hashcode ^= property.getName().toLowerCase().hashCode();
            if (property.getValue() == null || (value = property.getValue()) == null || value.getValue() == null) continue;
            hashcode ^= value.getValue().hashCode();
        }
        return hashcode;
    }

    public boolean equals(Object o) {
        return this.equals(o, true);
    }

    private void parseOp(String op) {
        String host = "";
        String namespace = "";
        String classname = "";
        String values = "";
        int hostIndexBegin = op.indexOf("//");
        int hostIndexEnd = op.indexOf("/", hostIndexBegin + 2);
        if (hostIndexBegin != -1) {
            host = op.substring(hostIndexBegin + 2, hostIndexEnd);
            op = op.substring(hostIndexEnd);
        }
        int cnIndex = op.indexOf(46);
        int nsIndex = -1;
        if (cnIndex != -1 && op.charAt(cnIndex - 1) == '/') {
            cnIndex = op.indexOf(46, cnIndex + 1);
        }
        if ((nsIndex = cnIndex == -1 ? op.lastIndexOf(58, op.length()) : op.lastIndexOf(58, cnIndex)) != -1) {
            namespace = op.substring(0, nsIndex);
            if (namespace.equals(":")) {
                namespace = "";
            }
            if (namespace.startsWith("//")) {
                int idx = namespace.indexOf(47, 2);
                if (idx == -1) {
                    host = namespace.substring(2);
                    namespace = "";
                } else {
                    host = namespace.substring(2, idx);
                    namespace = namespace.substring(idx + 1);
                }
            }
            ++nsIndex;
        } else {
            nsIndex = 0;
        }
        if (cnIndex != -1) {
            classname = op.substring(nsIndex, cnIndex);
            values = op.substring(cnIndex + 1, op.length());
        } else {
            classname = op.substring(nsIndex, op.length());
        }
        Vector<CIMProperty> keys = new Vector<CIMProperty>();
        if (values.length() != 0) {
            String[] propertyList = CIMObjectPath.parsePropertyList(values);
            for (int i = 0; i < propertyList.length; ++i) {
                int eqIndex = propertyList[i].indexOf(61);
                if (eqIndex == -1) {
                    throw new IllegalArgumentException("Invalid property initialization " + propertyList[i] + " there is no '='.");
                }
                CIMProperty cp = new CIMProperty();
                cp.setName(propertyList[i].substring(0, eqIndex));
                String value = propertyList[i].substring(eqIndex + 1);
                value = StringUtil.unquote(value);
                cp.setValue(new CIMValue(value));
                keys.addElement(cp);
            }
        }
        this.setHost(host);
        this.setNameSpace(namespace);
        this.setObjectName(classname);
        this.setKeys(keys);
    }

    private static String[] parsePropertyList(String properties) {
        ArrayList<String> propertyList = new ArrayList<String>();
        boolean inQuotes = false;
        int lastComma = 0;
        int length = properties.length();
        for (int i = 0; i < length; ++i) {
            char c = properties.charAt(i);
            if (c == '\"') {
                inQuotes = !inQuotes;
                continue;
            }
            if (inQuotes || c != ',') continue;
            propertyList.add(properties.substring(lastComma, i));
            lastComma = i + 1;
        }
        if (inQuotes) {
            throw new IllegalArgumentException("String literal is not properly closed by a double quote:" + properties);
        }
        if (lastComma >= length) {
            throw new IllegalArgumentException("Found a comma, but there was now subsequent property and value: " + properties);
        }
        propertyList.add(properties.substring(lastComma));
        return propertyList.toArray(new String[0]);
    }

    public Object clone() {
        CIMObjectPath cop = new CIMObjectPath();
        cop.setObjectName(this.objectName);
        cop.setHost(this.host);
        cop.setNameSpace(this.nameSpace);
        cop.setKeys((Vector)this.keys.clone());
        return cop;
    }

    public boolean equals(Object o, boolean ignoreClassOrigin) {
        if (!(o instanceof CIMObjectPath)) {
            return false;
        }
        CIMObjectPath inp = (CIMObjectPath)o;
        if (inp.host == null ? this.host != null && this.host.length() != 0 : !inp.host.equalsIgnoreCase(this.host)) {
            return false;
        }
        if (inp.nameSpace == null ? this.nameSpace != null && this.nameSpace.length() != 0 : !inp.nameSpace.equalsIgnoreCase(this.nameSpace)) {
            return false;
        }
        if (inp.objectName == null ? this.objectName != null && this.objectName.length() != 0 : !inp.objectName.equalsIgnoreCase(this.objectName)) {
            return false;
        }
        if (inp.keys == null) {
            if (this.keys != null) {
                return false;
            }
        } else {
            CIMProperty pe;
            int i;
            if (this.keys == null) {
                return false;
            }
            if (inp.keys.size() != this.keys.size()) {
                return false;
            }
            Hashtable<String, CIMProperty> ht = new Hashtable<String, CIMProperty>();
            for (i = 0; i < this.keys.size(); ++i) {
                pe = (CIMProperty)this.keys.elementAt(i);
                if (ignoreClassOrigin) {
                    ht.put(pe.getName().toLowerCase(), pe);
                    continue;
                }
                ht.put(pe.getOriginClass().toLowerCase() + "." + pe.getName().toLowerCase(), pe);
            }
            for (i = 0; i < this.keys.size(); ++i) {
                CIMProperty ipe = (CIMProperty)inp.keys.elementAt(i);
                pe = ignoreClassOrigin ? (CIMProperty)ht.get(ipe.getName().toLowerCase()) : (CIMProperty)ht.get(ipe.getOriginClass().toLowerCase() + "." + ipe.getName().toLowerCase());
                if (pe == null) {
                    return false;
                }
                CIMValue val = pe.getValue();
                CIMValue ival = ipe.getValue();
                if (!(ival == null ? val != null : !ival.equals(val))) continue;
                return false;
            }
        }
        return true;
    }
}

