/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.cim;

import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMMethod;
import javax.wbem.cim.CIMObject;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMQualifiedElement;
import javax.wbem.cim.CloneUtil;
import javax.wbem.cim.MOFFormatter;

public class CIMClass
extends CIMObject {
    static final long serialVersionUID = 200L;
    private String superClass = "";
    private boolean isAssociationClass;
    private boolean isKeyedClass;
    private Vector methods = new Vector();
    private Vector allmethods = new Vector();

    public CIMClass() {
        this("");
    }

    public CIMClass(String name) {
        super(name);
    }

    public String toString() {
        return this.toMOF();
    }

    public String toMOF() {
        MOFFormatter mf = new MOFFormatter();
        return mf.toString(this);
    }

    public String getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(String superClass) {
        this.superClass = superClass;
    }

    public boolean isKeyed() {
        return this.isKeyedClass;
    }

    public void setIsKeyed(boolean isKeyedValue) {
        this.isKeyedClass = isKeyedValue;
    }

    public CIMMethod getMethod(String name) {
        if (this.allmethods == null || name == null) {
            return null;
        }
        int i = name.indexOf(46);
        if (i != -1) {
            return this.getMethod(name.substring(i + 1, name.length()), name.substring(0, i));
        }
        int tempIndex = this.allmethods.indexOf(new CIMMethod(name));
        if (tempIndex == -1) {
            return null;
        }
        CIMMethod me = (CIMMethod)this.allmethods.elementAt(tempIndex);
        String override = me.getOverridingMethod();
        if (override != null) {
            me = this.getMethod(override);
        }
        return me;
    }

    public CIMMethod getMethod(String name, String originClass) {
        if (this.allmethods == null || name == null) {
            return null;
        }
        if (originClass == null || originClass.length() == 0) {
            return this.getMethod(name);
        }
        Enumeration methods = this.allmethods.elements();
        while (methods.hasMoreElements()) {
            CIMMethod method = (CIMMethod)methods.nextElement();
            if (!method.getName().equalsIgnoreCase(name) || !method.getOriginClass().equalsIgnoreCase(originClass)) continue;
            if (method.getOverridingMethod() != null) {
                return this.getMethod(method.getOverridingMethod());
            }
            return method;
        }
        return null;
    }

    public boolean isAssociation() {
        return this.isAssociationClass;
    }

    public void setIsAssociation(boolean association) {
        this.isAssociationClass = association;
    }

    public Vector getAllProperties() {
        return this.allproperties;
    }

    public Vector getAllMethods() {
        return this.allmethods;
    }

    public Vector getMethods() {
        return this.methods;
    }

    public void addProperty(CIMProperty property) {
        super.addProperty(property);
    }

    public int numberOfProperties() {
        return this.properties.size();
    }

    public int numberOfQualifiers() {
        return this.qualifiers.size();
    }

    public void addMethod(CIMMethod method) {
        if (method.getOverridingMethod() == null) {
            this.methods.add(method);
        }
        this.allmethods.add(method);
    }

    public void setMethods(Vector methods) {
        this.methods = new Vector();
        this.allmethods = new Vector();
        if (methods != null) {
            int size = methods.size();
            for (int i = 0; i < size; ++i) {
                this.addMethod((CIMMethod)methods.elementAt(i));
            }
        }
    }

    public CIMInstance newInstance() {
        CIMInstance ci = new CIMInstance();
        ci.setClassName(this.name);
        ci.setObjectPath(this.getObjectPath());
        if (this.allproperties != null) {
            ci.setProperties(CloneUtil.cloneProperties(this.allproperties, true));
        }
        return ci;
    }

    public CIMClass localElements() {
        Vector<CIMQualifiedElement> ov;
        CIMClass cc = new CIMClass();
        cc.name = this.name;
        cc.superClass = this.superClass;
        cc.isAssociationClass = this.isAssociationClass;
        cc.isKeyedClass = this.isKeyedClass;
        cc.setObjectPath(this.getObjectPath());
        if (this.properties != null) {
            ov = new Vector<CIMQualifiedElement>();
            Enumeration eProps = this.properties.elements();
            while (eProps.hasMoreElements()) {
                CIMProperty pe = (CIMProperty)eProps.nextElement();
                if (!pe.getOriginClass().equalsIgnoreCase(this.name)) continue;
                ov.add(pe);
            }
            cc.setProperties(ov);
        }
        if (this.methods != null) {
            ov = new Vector();
            Enumeration eMethods = this.methods.elements();
            while (eMethods.hasMoreElements()) {
                CIMMethod me = (CIMMethod)eMethods.nextElement();
                if (!me.getOriginClass().equalsIgnoreCase(this.name)) continue;
                ov.add(me);
            }
            cc.setMethods(ov);
        }
        cc.setQualifiers(this.qualifiers);
        return cc;
    }

    public CIMClass filterProperties(String[] propertyList, boolean includeQualifier, boolean includeClassOrigin) {
        Vector propList = this.getFilteredProperties(propertyList, includeQualifier, includeClassOrigin);
        Vector methodList = null;
        if (this.allmethods != null && propertyList == null) {
            methodList = CloneUtil.cloneMethods(this.allmethods, includeQualifier, includeClassOrigin);
        }
        CIMClass cc = new CIMClass();
        cc.name = this.name;
        cc.superClass = this.superClass;
        cc.isAssociationClass = this.isAssociationClass;
        cc.isKeyedClass = this.isKeyedClass;
        cc.setProperties(propList);
        cc.setMethods(methodList);
        if (includeQualifier) {
            cc.setQualifiers(this.qualifiers);
        }
        return cc;
    }
}

